import asyncio

from pylog.pylogger import PyLogger

from py_pli.pylib import GlobalVar
from predefined_tasks.common.helper import send_to_gc

from urpc.urpcendpoint import UrpcFirmwareException
from urpc_enum.error import I2CErrorCode

from fleming.common.firmware_util import *


async def tmp0_read_continuously(duration=60, interval=0.5):
#Test the Temperature Sensor on FMB, connected to TMP0.
#Hot plug possible, continuous reading.
#Script v1.0, 30.01.2023, including FMB Reset on I²C errors.

    duration = float(duration) if (duration != '') else 60
    interval = float(interval) if (interval != '') else 0.5

    GlobalVar.set_stop_gc(False)

    await send_to_gc(f"Starting Firmware")
    await start_firmware('fmb')

    fmb = get_node_endpoint('fmb')

    for i in range(round(duration / interval)):
        await asyncio.sleep(interval)
        try:
            temp = (await fmb.GetAnalogInput(FMBAnalogInput.EXTTEMP0))[0]
            await send_to_gc(f"{(temp * 256):.2f}°C", log=True)
        except UrpcFirmwareException as ex:
            if ex.errorCode == I2CErrorCode.AcknowledgeFailure:
                await send_to_gc(f"no sensor")
            else:
                await send_to_gc(f"{ex}", log=True)
                await send_to_gc(f"Restarting FMB...")
                await fmb.Reset()
                await asyncio.sleep(0.5)
                await start_firmware('fmb')

        if GlobalVar.get_stop_gc():
            return f"tmp0_read_continuously stopped by user"

    return f"tmp0_read_continuously done"

